/* 
   CC0 2011, Martin Haye

   To the extent possible under law, Martin Haye has waived all copyright 
   and related or neighboring rights to p2e: Pseudo-II Emulator. 
   This work is published from: United States.
*/


function setEmuStatus(str1, str2)
{
  $('emuStatus').innerHTML = str1;
  if (str2 === undefined)
    str2 = "&#160;";
  $('emuStatus2').innerHTML = str2;
}

function enable(elName)
{
  var el = $(elName);
  if (el)
    el.removeAttribute("disabled");
}

function disable(elName)
{
  var el = $(elName);
  if (el)
    el.setAttribute("disabled", "disabled");
}

function loadFile(fileName, useProxy)
{
  var url = useProxy ? "/cgi-bin/downloadDisk.py?target=" + fileName : fileName;
  var req = new XMLHttpRequest();
  req.open("GET", url, false);
  req.overrideMimeType("text/plain; charset=x-user-defined");
  req.send(null);
  if (req.status == 200)
    return req.responseText;
  console.debug("Warning: load of file '" + fileName + "' failed.");
  return null;
}

function initLocalStorage()
{
  if (!("targetSpeed" in localStorage))
    localStorage['targetSpeed'] = 1.0;
  if (!("showStats" in localStorage))
    localStorage['showStats'] = false;
  if (!("showDebugInfo" in localStorage))
    localStorage['showDebugInfo'] = false;

  if (!("Super-Mon.dsk" in localStorage))
    localStorage['Super-Mon.dsk'] = loadFile("https://bitbucket.org/martin.haye/super-mon/downloads/Super-Mon%201.1.dsk", true);
}

function emuInit()
{
  initLocalStorage();
  setSpeed(localStorage['targetSpeed']);
  setShowStats(localStorage['showStats'] == 'true');
  setShowDebugInfo(localStorage['showDebugInfo'] == 'true');
  
  updateKeyboardPosition();  
  
  setEmuStatus("Initializing 6502");
  init6502($('emu-canvas'));
  
  setEmuStatus("Loading charset");
  var charData = loadFile("charset.dat", false);
  setCharset(charData);  
  
  setEmuStatus("Loading ROM");
  if (!('Apple2e.rom' in localStorage))
    localStorage['Apple2e.rom'] = loadFile("http://mirrors.apple2.org.za/apple.cabi.net/A2.ROM.Images/appleIIe.(128k).rom", true);
  setAppleRom(localStorage['Apple2e.rom']);

  emuGo();
}

function updateKeyboardPosition()
{
  // Make the keyboard overlap the canvas except for part on the left for
  // the stupid blinking cursor on iOS.
  //
  var leftBarWidth = 10;
  var kbdLeft = parseInt($('keyboard').offsetLeft);
  var canvasLeft = parseInt($('emu-canvas').offsetLeft);
  if (kbdLeft != canvasLeft - leftBarWidth) {
    $('keyboard').style.left = (canvasLeft - leftBarWidth) + "px";
    $('keyboard').style.top = $('emu-canvas').offsetTop + "px";
    $('keyboard').style.width = ($('emu-canvas').offsetWidth + leftBarWidth) + "px";
    $('keyboard').style.height = $('emu-canvas').offsetHeight + "px";
  }
}

function emuGo() 
{  
  setEmuStatus("Running");
  
  run6502();
  
  paused = false;
  //$("emuPauseResume").innerHTML = "Pause";
  //enable("emuPauseResume");
  enable("emuBoot");
}

var paused = false;

function emuPauseResume(button)
{
  if (paused) {
    paused = false;
    button.innerHTML = "Pause";
    resume6502();
  }
  else {
    paused = true;
    button.innerHTML = "Resume";
    pause6502();
  }
}

function emuRestart(button)
{
  stop6502();
  emuGo();
}

// called when a page other than Main is selected
function emuPause() {
  pause6502();
}

function emuResume() {
  if (!paused)
    resume6502();
}

function showConfig() {
  var num = targetHz / 1000000;
  $("speedInput").value = num.toFixed(1).replace(/\.0+/, "");
  $("showStats").checked = localStorage['showStats'] == "true";
  $("showDebugInfo").checked = localStorage['showDebugInfo'] == "true";
  showPage("Config");
}

function onTargetSpeedChange(input) {
  setSpeed(parseFloat(input.value));
}

function setSpeed(num)
{
  if (num == NaN)
    num = 1.0;
  num = Math.max(0.5, Math.min(100, num));
  localStorage['targetSpeed'] = num.toFixed(1);
  setCpuSpeed(num);
}

function setVisible(el, flg)
{
  el.style.visibility = flg ? "visible" : "hidden";
}

function setShowStats(flg)
{
  localStorage['showStats'] = flg;
  setVisible($('emuStatus'), flg);
}

function setShowDebugInfo(flg)
{
  localStorage['showDebugInfo'] = flg;
  setVisible($('emuStatus2'), flg);
}

function onShowStatsChange(input) {
  setShowStats(input.checked);
  return true;
}

function onDebugInfoChange(input) {
  setShowDebugInfo(input.checked);
  return true;
}

function updateDiskTable()
{
  listEl = $('DiskBox');
  lines = [];
  for (var i=0; i<localStorage.length; i++) {
    var lsKey = localStorage.key(i);
    if (lsKey.match(/.*\.dsk/i)) 
      lines.push("<li><a onclick='onDiskClick(" + i + ");'>" + lsKey + "</a></li>\n");
  }
  lines.push("<li style='color:blue;'><a onclick='onAddDisk();'>Add Disk</a></li>\n");
  listEl.innerHTML = lines.join("\n");
}

var curDiskName;

function emuInsertEject(button)
{
  if (curDiskName) {
    // eject
    var diskData = ejectDisk();
    localStorage[curDiskName] = diskData;
    curDiskName = null;
    button.innerHTML = "Insert";
  }
  else {
    // insert
    updateDiskTable();
    showPage("DiskBox");
  }
}

function onLeaveMain()
{
  emuPause();
}

function onReturnToMain()
{
  emuResume();
}

function onAddDisk()
{
  //$('doAddDisk').style.display = 'block';
  //$('addStatus').style.display = 'none';
  $('addStatus').innerHTML = "";
  $('doSearchDisk').target = "";
  $('doSearchDisk').href = "#";
  showPage('AddDisk');
}

function onChangeSearchTerms(ctrl)
{
  $('doSearchDisk').href = "http://www.google.com/search?q=site:mirrors.apple2.org.za+%22parent+directory%22+%2Bdsk+" + ctrl.value;
  $('doSearchDisk').target = "_blank";
  console.log("changed href to: " + $('doSearchDisk').href);
}

var req = null;

function doAddDisk()
{
  if (req != null)
    return;
    
  var targetURL = $('diskURL').value;
  if (!targetURL.match(/^http/))
    alert("Sorry, only http and https\nURLs are supported.");
  var proxyURL = "/cgi-bin/downloadDisk.py?target=" + targetURL;
  //$('doAddDisk').style.display = 'none';
  //$('addStatus').style.display = 'block';
  $('addStatus').innerHTML = "Connecting...";
  
  // Fire up
  req = new XMLHttpRequest();
  req.open("GET", proxyURL, true);
  req.overrideMimeType("text/plain; charset=x-user-defined");
  req.onreadystatechange = function() {
    if (this.readyState == 3) {
      $('addStatus').innerHTML = "Receiving: " + this.responseText.length;
      return;
    }
    if (this.readyState != 4)
      return;
    if (this.status != 200) {
      $('addStatus').innerHTML = "Sorry, it failed (status=" + this.status + ")";
      req = null;
      return;
    }
    if (this.responseText == null) {
      $('addStatus').innerHTML = "Hmm, no response.";
      req = null;
      return;
    }
    
    // Figure out the filename.
    var slashPos = targetURL.lastIndexOf("/");
    var filename = "";
    if (slashPos >= 0) {
      filename = targetURL.substring(slashPos+1);
      filename = filename.replace(/\.(zip|gz)$/i, "");
      filename = filename.replace("%20", " ");
      if (filename.indexOf(".") < 0)
        filename += ".dsk";
    }
    
    console.debug("Got response text of length " + this.responseText.length);
    if (!filename.match(/.*\.dsk$/i) || this.responseText.length != 140*1024) {
      $('addStatus').innerHTML = "Not a disk image.";
      req = null;
      return;
    }
    
    localStorage[filename] = this.responseText;
    req = null;
    updateDiskTable();
    showPage("DiskBox");
  }
  req.send(null);
}

var optDiskName = null;

function onDiskClick(keyNum)
{
  optDiskName = localStorage.key(keyNum);
  $('DiskOptions').title = optDiskName;
  showPage("DiskOptions");
}

function onUseDisk()
{
  if (optDiskName != curDiskName) {
    $('emuInsertEject').innerHTML = "Eject";
    curDiskName = optDiskName;
    optDiskName = null;
    setTimeout(function() { // give UI time to finish updating
      insertDisk(localStorage[curDiskName]);
    }, 400);
  }
  showPage("Main");
}

function onDeleteDisk()
{
  localStorage.removeItem(optDiskName);
  updateDiskTable();
  showPage("DiskBox");
}

document.addEventListener("DOMContentLoaded", emuInit, false);
